struct SItem
{
    //    int docNo;
    int pageNo;
    int index;
    int wordId;
    int keywordIndex;
    int previousWordId;
    //    int newIndex;
    //    int distance;
    //    int foundcount;
    int fontSize;
    int wcount;
    bool inTirnak;
    bool isSimilar;
    bool similarHasReal;
    int similarity;
    int groupId;
    //    bool must;
};

__kernel void search(
                     __global struct SItem* input,
                     __global int* output,
                     const unsigned int count,
                     const unsigned int pagecount,
                     const unsigned int keywordcount)
{
    int scopedistance = 250;
    
    for (int i1=0;i1<count;i1++) {
        struct SItem item1 = input[i1];
        for (int i2=count-1;i2>=i1;i2--) {
            struct SItem item2 = input[i2];
            
            int item1FactorIndex = (item1.pageNo-1)*keywordcount + item1.keywordIndex;
            int item2FactorIndex = (item2.pageNo-1)*keywordcount + item2.keywordIndex;
            
            int factorItem1=0;
            int factorItem2=0;
            
            if (item1.index!=item2.index) {
                int dist = item1.index - item2.index;
                if (abs(dist)<scopedistance) {
                    
                    /*
                    if ((item1.inTirnak || item2.inTirnak) && item1.groupId!=item2.groupId)
                        continue;
                    
                    
                    if (item1.inTirnak && item2.inTirnak) {
                        if (dist==1) {
                            if (item1.previousWordId>-1) {
                                if (item1.previousWordId!=item2.wordId) {
                                    continue;
                                }
                            } else continue;
                        } else if (dist==-1) {
                            if (item2.previousWordId>-1) {
                                if (item2.previousWordId!=item1.wordId) {
                                    continue;
                                }
                            } else continue;
                        } else {
                            //    if (item1.previousWordArray || item2.previousWordArray) {
                            continue;
                            //    }
                        }
                    }
                     */
                    
                    if (item1.wordId==item2.wordId) {
                        if (item1.inTirnak || item2.inTirnak) continue;
                        int ds = 100;
                        if (item1.isSimilar) {
                            if (item1.similarHasReal)
                                ds = item1.similarity / 10 + 5;
                            else
                                ds = item1.similarity;
                        }

                        int factor = item1.fontSize * ds - item1.wcount;
                        int wordFactor = output[item1FactorIndex];
                        if (wordFactor>0) {
                            if (factor>wordFactor) {
                                factorItem1 = factor;
                            }
                        } else {
                            factorItem1 = factor;
                        }
                    } else {
                        int ds = 100;
                        int ds1 = 20000000;
                        int ds2 = 20000000;
                        if (dist==1) {
                            if (item1.previousWordId>-1) {
                                if (item1.previousWordId==item2.wordId) {
                                    ds1 = 25000000;
                                    ds2 = 25000000;
                                }
                            }
                        } else if (dist==-1) {
                            if (item2.previousWordId>-1) {
                                if (item2.previousWordId==item1.wordId) {
                                    ds1 = 25000000;
                                    ds2 = 25000000;
                                }
                            }
                        }
                        

                        if (item1.isSimilar && item2.isSimilar) {
                            if (item1.similarHasReal)
                                ds1 = 0;
                            else
                                ds1 = ds1 / 1000;

                            if (item2.similarHasReal)
                                ds2 = 0;
                            else
                                ds2 = ds2 / 1000;

                            ds = item1.similarity / 10 + 5;
                        } else if (!item1.isSimilar && item2.isSimilar) {
                            if (item2.similarHasReal) {
                                ds2 = 0;
                                ds1 = 0;
                                ds = 5;
                            }
                            else {
                                ds2 = ds2 / 1000;
                                ds = item2.similarity;
                            }
                        } else if (item1.isSimilar && !item2.isSimilar) {
                            if (item1.similarHasReal) {
                                ds1 = 0;
                                ds2 = 0;
                                ds = 5;
                            }
                            else {
                                ds1 = ds1 / 1000;
                                ds = item1.similarity;
                            }
                        }

                        int factor1 = item1.fontSize * ds + ds1 / (dist * dist) - item1.wcount - item2.wcount; // - abs((doc.pageCount) - item1.pageNo) ;
                        int wordFactor1 = output[item1FactorIndex];
                        if (wordFactor1>0) {
                            if (factor1>wordFactor1) {
                                factorItem1 = factor1;
                            }
                        } else {
                            factorItem1 = factor1;
                        }

                        
                        int factor2 = item2.fontSize * ds +  ds2 / (dist * dist) - item2.wcount - item1.wcount; // - abs((doc.pageCount) - item2.pageNo);
                        int wordFactor2 = output[item2FactorIndex];
                        if (wordFactor2>0) {
                            if (factor2>wordFactor2) {
                                factorItem2 = factor2;
                            }
                        } else {
                            factorItem2 = factor2;
                        }
                    }
                }
            } else {
                if ((item1.inTirnak || (item2.inTirnak)) && keywordcount>1) continue;
                int ds = 100;
                if (item1.isSimilar) {
                    if (item1.similarHasReal)
                        ds = item1.similarity / 10 + 5;
                    else
                        ds = item1.similarity;
                }

                int factor = item1.fontSize * ds - item1.wcount;
                int wordFactor = output[item1FactorIndex];
                if (wordFactor>0) {
                    if (factor>wordFactor) {
                        factorItem1 = factor;
                    }
                } else {
                    factorItem1 = factor;
                }
            }
            
            if (factorItem1>0)
                output[item1FactorIndex] = factorItem1;
            if (factorItem2>0)
                output[item2FactorIndex] = factorItem2;
            
            
        }
    }
}

